<div class="interactive-map-container">
    <div class="map-controls">
        <button class="map-control-btn" id="zoom-in">
            <i class="fas fa-plus"></i>
        </button>
        <button class="map-control-btn" id="zoom-out">
            <i class="fas fa-minus"></i>
        </button>
        <button class="map-control-btn" id="reset-view">
            <i class="fas fa-sync-alt"></i>
        </button>
    </div>
    
    <div class="map-info-panel" id="location-info">
        <div class="info-header">
            <h3 id="location-name">Select a location</h3>
            <button class="close-btn" id="close-info">×</button>
        </div>
        <div class="info-content">
            <p id="location-description">Click on a marker to see details about that location.</p>
            <div id="location-details"></div>
        </div>
    </div>

    <div class="map-legend">
        <h4>Map Legend</h4>
        <div class="legend-item">
            <span class="marker government"></span>
            <span>Government</span>
        </div>
        <div class="legend-item">
            <span class="marker commercial"></span>
            <span>Commercial</span>
        </div>
        <div class="legend-item">
            <span class="marker residential"></span>
            <span>Residential</span>
        </div>
        <div class="legend-item">
            <span class="marker illegal"></span>
            <span>Illegal</span>
        </div>
        <div class="legend-item">
            <span class="marker public"></span>
            <span>Public</span>
        </div>
    </div>
    
    <div class="map-wrapper" id="map-wrapper">
        <div class="map-container" id="map-container">
            @php
                $mapSettings = \App\Models\MapSetting::first();
                $mapImagePath = $mapSettings && $mapSettings->image_path 
                    ? Storage::url($mapSettings->image_path) 
                    : asset('images/download.jpeg');
                    
                $locations = \App\Models\MapLocation::where('is_active', true)
                    ->orderBy('order')
                    ->get()
                    ->map(function($location) {
                        return [
                            'id' => $location->id,
                            'name' => $location->name,
                            'description' => $location->description,
                            'x' => $location->x,
                            'y' => $location->y,
                            'type' => $location->type,
                            'details' => $location->details ?? null
                        ];
                    })
                    ->toArray();
            @endphp
            <img src="{{ $mapImagePath }}" alt="Server Map" id="map-image">
            <div id="map-markers"></div>
        </div>
    </div>
</div>

@push('scripts')
<script>
    window.mapLocations = @json($locations);
    console.log('Map locations loaded:', window.mapLocations);
    
    @if(!isset($mapScriptLoaded))
        @php $mapScriptLoaded = true; @endphp
    @endif
</script>
@endpush